# FreqLab (FFT plugin for Krita)

This plugin shows a log-magnitude FFT preview of the selected ROI and can apply low/high/band-pass radial masks using NumPy's FFT when available.

Install:

1. Copy the `FFT` folder into Krita's `pykrita` directory (`%APPDATA%\\krita\\pykrita` on Windows).
2. If you want the full Apply feature, ensure Krita's bundled Python has NumPy installed; otherwise only the small preview (DFT fallback) will work.
3. Restart Krita and enable the plugin in the Python Plugin Manager.

Usage:

- Tools → Scripts → FreqLab
- Preview: shows log(1+|FFT|) with DC centered (fftshift). If NumPy is available preview uses max side 256, otherwise falls back to a small 64×64 DFT preview.
- Window: choose `hann` to apply a Hann window before FFT to reduce ringing.
- Filter: choose low-pass, high-pass, or band-pass and set radii (pixels in frequency grid) for the mask.
- Apply: available only if NumPy is available — runs full-size FFT filter and writes the result as grayscale RGB back into the ROI (alpha preserved).

Notes and limitations:

- This is a teaching/demo plugin. For large images Apply may take time and has no progress UI.
- Without NumPy Apply is disabled (fallback is only for preview).
