# BatchLab (Batch export & Sprite-Sheet plugin)

Install:

1. Copy the `batch_export` folder into Krita's `pykrita` directory (`%APPDATA%\\krita\\pykrita` on Windows).
2. Restart Krita and enable the plugin in Settings → Configure Krita → Python Plugin Manager.

Features (implemented):

- Batch Export tab: scope selection, format/quality, scaling, trim/padding, filename template, destination selection, preview and run.
- Sprite-Sheet tab: input selection (selected layers or PNGs from a directory), grid/tight-pack simulated preview, padding/extrude options, power-of-two option.
- Run uses `QProgressDialog` and supports user cancel (best-effort).
- Settings are persisted with `QSettings` (last used destination paths).

Notes & limitations:

- This implementation is a functional skeleton with placeholders where a full Krita integration would require more API calls (e.g., rendering layers to images, precise trimming, resampling, and tile extrusion). Those are indicated in code comments and are straightforward to complete with Krita's API (renderToImage, QImage scaling, etc.).
- Export currently writes raw `pixelData` bytes to files as a placeholder — replace with proper QImage saving per format using PyQt/Krita APIs for real exported images.
- Sprite-sheet packing currently simulates layout; a full tight-packer (maxrects / guillotine) can be integrated later.

If you want, I can now:

- Implement accurate layer rendering → QImage → format exports (PNG/WebP/JPEG/TIFF) with quality and bit-depth control.
- Implement trim bbox detection and padding correctly.
- Implement tile extrusion and tight-pack algorithm and output manifest JSON.
